/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.IIndexChangeListener;
import com.aptana.editor.php.indexer.IIndexReporter;
import com.aptana.editor.php.indexer.IModuleIndexListener;
import com.aptana.editor.php.indexer.IModuleIndexer;
import com.aptana.editor.php.indexer.IProgramIndexer;
import com.aptana.editor.php.indexer.IReportable;
import com.aptana.editor.php.indexer.Messages;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.FileSystemBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathChangeListener;
import com.aptana.editor.php.internal.core.builder.IBuildPathsListener;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.ComplexIndex;
import com.aptana.editor.php.internal.indexer.IndexPersistence;
import com.aptana.editor.php.internal.indexer.UnpackedElementIndex;
import com.aptana.editor.php.internal.indexer.language.PHPBuiltins;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org2.eclipse.php.internal.core.ast.nodes.Program;

public final class PHPGlobalIndexer {
    public static final Object FAMILY_PHP_BUILD = new Object();
    private static Object mutex = new Object();
    private static final int SAVING_INTERVAL = 10000;
    Thread saverThread = new Thread("PHPGlobalIndexer saver"){

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(10000L);
                    try {
                        PHPGlobalIndexer.this.doSave();
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error saving the PHP index", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                    }
                }
            }
            catch (InterruptedException e) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Saving the PHP index was interrupted", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                return;
            }
        }
    };
    private static final String EXTENSION_POINT_NAME = "com.aptana.editor.php.indexer";
    private static final String INDEXER_ELEMENT_NAME = "indexer";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static PHPGlobalIndexer instance;
    private ComplexIndex mainIndex;
    private List<IModuleIndexer> moduleIndexers;
    private IBuildPathChangeListener buildPathChangeListener;
    private Set<IIndexChangeListener> listeners = new HashSet<IIndexChangeListener>();
    private Set<IModuleIndexListener> moduleIndexListeners = new HashSet<IModuleIndexListener>();
    static Set<IBuildPath> needSaving;
    private Map<String, String> pathes;
    int modulesNum = 0;

    static {
        needSaving = new HashSet<IBuildPath>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PHPGlobalIndexer getInstance() {
        Object object = mutex;
        synchronized (object) {
            if (instance == null) {
                instance = new PHPGlobalIndexer();
            }
            return instance;
        }
    }

    public IElementsIndex getIndex() {
        return this.mainIndex;
    }

    private PHPGlobalIndexer() {
        this.createMainIndex();
        PHPEditorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("phpVersion")) {
                    PHPGlobalIndexer.getInstance().cleanLibraries((IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
        this.collectModuleIndexersInfo();
        this.initPersistence();
        this.buildPathChangeListener = new IBuildPathChangeListener(){

            public void changedBefore(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
                PHPGlobalIndexer.this.processChangedBefore(changed, removed, removedDirectories);
            }

            public void changedAfter(List<IModule> added, List<IModule> changed, List<IModule> removed, List<IDirectory> addedDirectories, List<IDirectory> removedDirectories) {
                PHPGlobalIndexer.this.processChangedAfter(added, changed, removed, addedDirectories, removedDirectories);
            }
        };
        this.indexLocalModules();
        BuildPathManager.getInstance().addBuildPathChangeListener(new IBuildPathsListener(){

            public void changed(List<IBuildPath> added, List<IBuildPath> removed) {
                Job job;
                for (IBuildPath path : removed) {
                    path.removeBuildPathChangeListener(PHPGlobalIndexer.this.buildPathChangeListener);
                    PHPGlobalIndexer.this.mainIndex.removeIndex(path);
                    if (!path.isPassive()) continue;
                    job = PHPGlobalIndexer.this.handleModulesRemoved(path.getModules());
                    job.setPriority(40);
                    job.schedule();
                }
                for (IBuildPath path : added) {
                    PHPGlobalIndexer.this.mainIndex.addIndex(path, new UnpackedElementIndex());
                    path.addBuildPathChangeListener(PHPGlobalIndexer.this.buildPathChangeListener);
                    if (!path.isPassive()) continue;
                    job = PHPGlobalIndexer.this.handleModulesAdded(path.getModules());
                    job.setPriority(40);
                    job.schedule();
                }
            }
        });
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                File indexFile;
                IBuildPath buildPath;
                IResource resource = event.getResource();
                if (resource instanceof IProject && (buildPath = BuildPathManager.getInstance().getBuildPathByResource(resource)) != null && (indexFile = PHPGlobalIndexer.this.getIndexFile(buildPath)) != null && indexFile.exists()) {
                    indexFile.delete();
                }
            }
        }, 4);
    }

    private void initPersistence() {
        this.saverThread.setDaemon(true);
        this.saverThread.start();
    }

    private void createMainIndex() {
        this.mainIndex = new ComplexIndex();
    }

    private Job handleModulesRemoved(final List<IModule> modules) {
        Job job = new Job(Messages.PHPGlobalIndexer_RemovingModuleIndex2){

            public IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                monitor.beginTask(Messages.PHPGlobalIndexer_RemovingModuleIndex2, modules.size());
                PHPGlobalIndexer.this.fireChanged(modules.size());
                int i = 0;
                while (i < modules.size()) {
                    if (monitor.isCanceled()) break;
                    IModule module = (IModule)modules.get(i);
                    PHPGlobalIndexer.this.mainIndex.removeModuleEntries(module, module.getBuildPath());
                    monitor.worked(1);
                    UnpackedElementIndex elementIndex = (UnpackedElementIndex)PHPGlobalIndexer.this.mainIndex.getElementIndex(module.getBuildPath());
                    if (elementIndex != null) {
                        elementIndex.removeTimeStamp(module);
                    }
                    ++i;
                }
                monitor.done();
                PHPGlobalIndexer.this.markDirtyPathes(modules);
                PHPGlobalIndexer.this.fireChanged(0);
                IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("Indexer handleModulesRemoved [took " + (System.currentTimeMillis() - start) + "ms)"), null, (String)"com.aptana.editor.php/debug/indexer");
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family == FAMILY_PHP_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirtyPathes(List<IModule> modules) {
        Set<IBuildPath> set = needSaving;
        synchronized (set) {
            for (IModule m : modules) {
                needSaving.add(m.getBuildPath());
            }
        }
    }

    private Job handleModulesChanged(final List<IModule> modules) {
        Job job = new Job(Messages.PHPGlobalIndexer_IndexChanged){

            public IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                monitor.beginTask(Messages.PHPGlobalIndexer_IndexChanged2, modules.size());
                PHPGlobalIndexer.this.fireChanged(modules.size());
                int i = 0;
                while (i < modules.size()) {
                    IModule module = (IModule)modules.get(i);
                    long l = module.getTimeStamp();
                    PHPGlobalIndexer.this.mainIndex.removeModuleEntries(module, module.getBuildPath());
                    for (IModuleIndexer indexer : PHPGlobalIndexer.this.moduleIndexers) {
                        if (monitor.isCanceled()) break;
                        indexer.indexModule(module, new IIndexReporter(){

                            @Override
                            public IElementEntry reportEntry(int category, String entryPath, IReportable value, IModule module) {
                                return PHPGlobalIndexer.this.mainIndex.addEntry(category, entryPath, value, module, module.getBuildPath());
                            }
                        });
                    }
                    UnpackedElementIndex elementIndex = (UnpackedElementIndex)PHPGlobalIndexer.this.mainIndex.getElementIndex(module.getBuildPath());
                    if (elementIndex != null) {
                        elementIndex.recordTimeStamp(module, l);
                    }
                    if (monitor.isCanceled()) break;
                    monitor.worked(1);
                    ++i;
                }
                PHPGlobalIndexer.this.fireChanged(0);
                PHPGlobalIndexer.this.markDirtyPathes(modules);
                monitor.done();
                IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("Indexer handleModulesChanged [took " + (System.currentTimeMillis() - start) + "ms)"), null, (String)"com.aptana.editor.php/debug/indexer");
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family == FAMILY_PHP_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        return job;
    }

    private Job handleModulesAdded(final List<IModule> modules) {
        Job job = new Job(Messages.PHPGlobalIndexer_IndexNew){

            public IStatus run(IProgressMonitor monitor) {
                long start = System.currentTimeMillis();
                PHPGlobalIndexer.this.fireChanged(modules.size());
                monitor.beginTask(Messages.PHPGlobalIndexer_IndexNew, modules.size());
                int i = 0;
                while (i < modules.size()) {
                    if (monitor.isCanceled()) break;
                    IModule module = (IModule)modules.get(i);
                    monitor.setTaskName(String.valueOf(Messages.PHPGlobalIndexer_IndexNew) + " - ../" + module.getShortName());
                    long l = module.getTimeStamp();
                    for (IModuleIndexer indexer : PHPGlobalIndexer.this.moduleIndexers) {
                        indexer.indexModule(module, new IIndexReporter(){

                            @Override
                            public IElementEntry reportEntry(int category, String entryPath, IReportable value, IModule module) {
                                return PHPGlobalIndexer.this.mainIndex.addEntry(category, entryPath, value, module, module.getBuildPath());
                            }
                        });
                    }
                    UnpackedElementIndex elementIndex = (UnpackedElementIndex)PHPGlobalIndexer.this.mainIndex.getElementIndex(module.getBuildPath());
                    if (elementIndex != null) {
                        elementIndex.recordTimeStamp(module, l);
                    }
                    monitor.worked(1);
                    ++i;
                }
                monitor.done();
                PHPGlobalIndexer.this.markDirtyPathes(modules);
                PHPGlobalIndexer.this.fireChanged(0);
                IdeLog.logInfo((Plugin)PHPEditorPlugin.getDefault(), (String)("Indexer handleModulesAdded [took " + (System.currentTimeMillis() - start) + "ms)"), null, (String)"com.aptana.editor.php/debug/indexer");
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (family == FAMILY_PHP_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == ResourcesPlugin.FAMILY_MANUAL_BUILD) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        return job;
    }

    private void collectModuleIndexersInfo() {
        this.moduleIndexers = new ArrayList<IModuleIndexer>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint ep = registry.getExtensionPoint(EXTENSION_POINT_NAME);
        if (ep != null) {
            IExtension[] extensions = ep.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    String elementName = element.getName();
                    if (elementName.equals(INDEXER_ELEMENT_NAME)) {
                        try {
                            this.moduleIndexers.add(new WrapIndexer(element));
                        }
                        catch (Throwable th) {
                            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)(String.valueOf(Messages.PHPGlobalIndexer_UnableLoad) + elementName + Messages.PHPGlobalIndexer_ProviderDecl), (Throwable)th, (String)"com.aptana.editor.php/debug/indexer");
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void save() {
        this.doSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() {
        if (EclipseUtil.isTesting()) {
            return;
        }
        HashSet<IBuildPath> bp = new HashSet<IBuildPath>();
        Set<IBuildPath> set = needSaving;
        synchronized (set) {
            bp.addAll(needSaving);
            needSaving.clear();
        }
        for (IBuildPath p : bp) {
            File indexFile = this.getIndexFile(p);
            if (indexFile == null) continue;
            FilterOutputStream stream = null;
            try {
                try {
                    stream = new BufferedOutputStream(new FileOutputStream(indexFile));
                    UnpackedElementIndex elementIndex = (UnpackedElementIndex)this.mainIndex.getElementIndex(p);
                    if (elementIndex != null) {
                        IndexPersistence.store(elementIndex, new DataOutputStream(stream), p);
                    }
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error saving the PHP index", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a stream", (Throwable)e2, (String)"com.aptana.editor.php/debug/indexer");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a stream", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                    }
                }
                throw throwable;
            }
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException e) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a stream", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
        }
    }

    private File getIndexFile(IBuildPath p) {
        String handleIdentifier;
        String string;
        if (this.pathes == null) {
            this.loadPathMappings();
        }
        if ((string = this.pathes.get(handleIdentifier = p.getHandleIdentifier())) != null) {
            File parent = PHPEditorPlugin.getDefault().getStateLocation().toFile();
            File pathesFile = new File(parent, "indexMappings");
            if (!pathesFile.exists()) {
                this.savePathMappings();
            }
            return new File(string);
        }
        int code = handleIdentifier.hashCode();
        File parent = PHPEditorPlugin.getDefault().getStateLocation().toFile();
        String sm = "" + code;
        while (this.pathes.get(new File(parent, sm).getAbsolutePath()) != null) {
            sm = String.valueOf(sm) + 'l';
        }
        File result = new File(parent, sm);
        this.pathes.put(handleIdentifier, result.getAbsolutePath());
        this.savePathMappings();
        return result;
    }

    private synchronized void loadPathMappings() {
        block15: {
            this.pathes = new HashMap<String, String>();
            File parent = PHPEditorPlugin.getDefault().getStateLocation().toFile();
            File pathesFile = new File(parent, "indexMappings");
            if (pathesFile.exists()) {
                FilterInputStream dataInputStream = null;
                try {
                    try {
                        dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(pathesFile)));
                        int readInt = ((DataInputStream)dataInputStream).readInt();
                        int a = 0;
                        while (a < readInt) {
                            String handle = ((DataInputStream)dataInputStream).readUTF();
                            String path = ((DataInputStream)dataInputStream).readUTF();
                            if (path != null && new File(path).exists()) {
                                this.pathes.put(handle, path);
                            }
                            ++a;
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading PHP index-mapping", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                        if (dataInputStream == null) break block15;
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e2) {
                            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e2, (String)"com.aptana.editor.php/debug/indexer");
                        }
                    }
                }
                finally {
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e) {
                            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                        }
                    }
                }
            }
        }
    }

    private synchronized void savePathMappings() {
        block13: {
            File parent = PHPEditorPlugin.getDefault().getStateLocation().toFile();
            File pathesFile = new File(parent, "indexMappings");
            FilterOutputStream dataOutputStream = null;
            try {
                try {
                    dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(pathesFile)));
                    ((DataOutputStream)dataOutputStream).writeInt(this.pathes.size());
                    for (String s : this.pathes.keySet()) {
                        ((DataOutputStream)dataOutputStream).writeUTF(s);
                        ((DataOutputStream)dataOutputStream).writeUTF(this.pathes.get(s));
                    }
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error saving PHP index-mapping", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                    if (dataOutputStream == null) break block13;
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e2, (String)"com.aptana.editor.php/debug/indexer");
                    }
                }
            }
            finally {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e) {
                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                    }
                }
            }
        }
    }

    public void indexLocalModules() {
        Job initializator = new Job(Messages.PHPGlobalIndexer_initializinIndex){

            protected IStatus run(IProgressMonitor monitor) {
                List<IBuildPath> paths = BuildPathManager.getInstance().getBuildPaths();
                for (IBuildPath path : paths) {
                    boolean loaded;
                    UnpackedElementIndex index;
                    ArrayList modules;
                    block23: {
                        if (monitor.isCanceled()) break;
                        modules = new ArrayList();
                        index = new UnpackedElementIndex();
                        loaded = false;
                        File indexFile = PHPGlobalIndexer.this.getIndexFile(path);
                        if (indexFile.exists()) {
                            FilterInputStream di = null;
                            try {
                                try {
                                    di = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
                                    try {
                                        IndexPersistence.load(index, (DataInputStream)di, path);
                                        loaded = true;
                                    }
                                    catch (Exception e) {
                                        indexFile.delete();
                                        if (!(e instanceof IOException)) {
                                            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error loading the PHP index", (Throwable)e);
                                        }
                                    }
                                }
                                catch (Exception e1) {
                                    IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing local PHP modules", (Throwable)e1, (String)"com.aptana.editor.php/debug/indexer");
                                    if (di != null) {
                                        try {
                                            di.close();
                                        }
                                        catch (IOException e) {
                                            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                                        }
                                    }
                                    break block23;
                                }
                            }
                            catch (Throwable throwable) {
                                if (di != null) {
                                    try {
                                        di.close();
                                    }
                                    catch (IOException e) {
                                        IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                                    }
                                }
                                throw throwable;
                            }
                            if (di != null) {
                                try {
                                    di.close();
                                }
                                catch (IOException e) {
                                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error closing a DataInputStream in the PHPGlobalIndexer", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
                                }
                            }
                        }
                    }
                    if (monitor.isCanceled()) break;
                    path.addBuildPathChangeListener(PHPGlobalIndexer.this.buildPathChangeListener);
                    modules.addAll(path.getModules());
                    if (!loaded) {
                        PHPGlobalIndexer.this.mainIndex.addIndex(path, new UnpackedElementIndex());
                        Job addedJob = PHPGlobalIndexer.this.handleModulesAdded(modules);
                        addedJob.schedule();
                        continue;
                    }
                    PHPGlobalIndexer.this.mainIndex.addIndex(path, index);
                    ArrayList<IModule> changed = new ArrayList<IModule>();
                    List<IModule> asList = Arrays.asList(index.getAllModules());
                    HashSet<Object> all = new HashSet<IModule>(asList);
                    for (IModule m : modules) {
                        long timeStamp2;
                        long timeStamp;
                        if (monitor.isCanceled()) break;
                        if (!all.contains(m) || (timeStamp = index.getTimeStamp(m)) == (timeStamp2 = m.getTimeStamp())) continue;
                        changed.add(m);
                    }
                    if (!changed.isEmpty()) {
                        Job changedJob = PHPGlobalIndexer.this.handleModulesChanged(changed);
                        changedJob.setPriority(40);
                        changedJob.schedule();
                    }
                    all.removeAll(modules);
                    if (!all.isEmpty()) {
                        Job removedJob = PHPGlobalIndexer.this.handleModulesRemoved(new ArrayList<IModule>(all));
                        removedJob.setPriority(40);
                        removedJob.schedule();
                    }
                    all = new HashSet(modules);
                    all.removeAll(asList);
                    if (all.isEmpty()) continue;
                    Job addedJob = PHPGlobalIndexer.this.handleModulesAdded(new ArrayList<Object>(all));
                    addedJob.setPriority(40);
                    addedJob.schedule();
                }
                return Status.OK_STATUS;
            }
        };
        initializator.setPriority(40);
        initializator.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        initializator.schedule();
    }

    public void processChangedBefore(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
        this.fireBeforeIndexing(changed, removed, removedDirectories);
    }

    public void processChangedAfter(final List<IModule> added, final List<IModule> changed, List<IModule> removed, final List<IDirectory> addedDirectories, List<IDirectory> removedDirectories) {
        final ArrayList<Job> jobs = new ArrayList<Job>();
        final ArrayList<Integer> sizes = new ArrayList<Integer>();
        if (changed.size() != 0) {
            jobs.add(this.handleModulesChanged(changed));
            sizes.add(changed.size());
        }
        if (added.size() != 0) {
            jobs.add(this.handleModulesAdded(added));
            sizes.add(added.size());
        }
        if (removed.size() != 0) {
            jobs.add(this.handleModulesRemoved(removed));
            sizes.add(removed.size());
        }
        int size = 0;
        int i = 0;
        while (i < sizes.size()) {
            size += ((Integer)sizes.get(i)).intValue();
            ++i;
        }
        final int summSize = size;
        if (size != 0) {
            Job complexJob = new Job(Messages.PHPGlobalIndexer_PHP_Index){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.PHPGlobalIndexer_PHP_Index2, summSize);
                    IProgressMonitor pgMonitor = 10.getJobManager().createProgressGroup();
                    pgMonitor.setTaskName(Messages.PHPGlobalIndexer_PHP_Index);
                    int i = 0;
                    while (i < jobs.size()) {
                        if (monitor.isCanceled() || pgMonitor.isCanceled()) break;
                        Job job = (Job)jobs.get(i);
                        job.setProgressGroup(pgMonitor, ((Integer)sizes.get(i)).intValue());
                        job.schedule();
                        try {
                            job.join();
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                    monitor.done();
                    pgMonitor.done();
                    PHPGlobalIndexer.this.fireChangeProcessed();
                    PHPGlobalIndexer.this.fireAfterIndexing(added, changed, addedDirectories);
                    return Status.OK_STATUS;
                }
            };
            complexJob.setPriority(40);
            complexJob.schedule();
        } else {
            this.fireAfterIndexing(added, changed, addedDirectories);
        }
    }

    public void processUnsavedModuleUpdate(Program program, IModule module, String source) {
        this.mainIndex.removeModuleEntries(module, module.getBuildPath());
        UnpackedElementIndex elementIndex = (UnpackedElementIndex)this.mainIndex.getElementIndex(module.getBuildPath());
        for (IModuleIndexer indexer : this.moduleIndexers) {
            if (!(indexer instanceof IProgramIndexer)) continue;
            ((IProgramIndexer)((Object)indexer)).indexModule(program, module, source, new IIndexReporter(){

                @Override
                public IElementEntry reportEntry(int category, String entryPath, IReportable value, IModule module) {
                    return PHPGlobalIndexer.this.mainIndex.addEntry(category, entryPath, value, module, module.getBuildPath());
                }
            });
        }
        if (elementIndex != null) {
            elementIndex.recordTimeStamp(module, -1L);
        }
        this.fireChanged(0);
        this.fireChangeProcessed();
    }

    private synchronized void fireChanged(int modulesLeft) {
        for (IIndexChangeListener l : this.listeners) {
            l.stateChanged(modulesLeft == 0, MessageFormat.format(Messages.PHPGlobalIndexer_ModulesLeft, modulesLeft));
        }
    }

    private synchronized void fireChangeProcessed() {
        for (IIndexChangeListener l : this.listeners) {
            l.changeProcessed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeIndexing(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
        ArrayList<IModuleIndexListener> listeners = new ArrayList<IModuleIndexListener>();
        Set<IModuleIndexListener> set = this.moduleIndexListeners;
        synchronized (set) {
            listeners.addAll(this.moduleIndexListeners);
        }
        for (IModuleIndexListener listener : listeners) {
            listener.beforeIndexChange(changed, removed, removedDirectories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAfterIndexing(List<IModule> added, List<IModule> changed, List<IDirectory> addedDirectories) {
        ArrayList<IModuleIndexListener> toNotify = new ArrayList<IModuleIndexListener>();
        Set<IModuleIndexListener> set = this.moduleIndexListeners;
        synchronized (set) {
            toNotify.addAll(this.moduleIndexListeners);
        }
        for (IModuleIndexListener listener : toNotify) {
            listener.afterIndexChange(added, changed, addedDirectories);
        }
    }

    public synchronized void addListener(IIndexChangeListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(IIndexChangeListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IModuleIndexListener listener) {
        Set<IModuleIndexListener> set = this.moduleIndexListeners;
        synchronized (set) {
            this.moduleIndexListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(IModuleIndexListener listener) {
        Set<IModuleIndexListener> set = this.moduleIndexListeners;
        synchronized (set) {
            this.moduleIndexListeners.remove(listener);
        }
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        if (project != null) {
            try {
                project.refreshLocal(2, monitor);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error cleaning the PHP index", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
            BuildPathManager buildPathManager = BuildPathManager.getInstance();
            IBuildPath buildPath = buildPathManager.getBuildPathByResource(project);
            if (buildPath != null) {
                File indexFile = this.getIndexFile(buildPath);
                if (indexFile != null && indexFile.exists()) {
                    indexFile.delete();
                }
                HashSet<IProject> targetProject = new HashSet<IProject>(1);
                HashSet<IProject> empty = new HashSet<IProject>(0);
                this.mainIndex.removeIndex(buildPath);
                buildPathManager.handleChanged(empty, targetProject);
                buildPathManager.handleChanged(targetProject, empty);
            }
        }
    }

    public void build(IProject project, IProgressMonitor monitor) {
        if (project != null) {
            BuildPathManager buildPathManager = BuildPathManager.getInstance();
            final IBuildPath newBuildPath = buildPathManager.getBuildPathByResource(project);
            this.mainIndex.addIndex(newBuildPath, new UnpackedElementIndex());
            Job job = this.handleModulesAdded(newBuildPath.getModules());
            job.setPriority(40);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            Job savingJob = new Job(Messages.PHPGlobalIndexer_savingIndex){

                protected IStatus run(IProgressMonitor monitor) {
                    needSaving.add(newBuildPath);
                    PHPGlobalIndexer.this.doSave();
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)savingJob);
            savingJob.setPriority(40);
        }
    }

    public void cleanAllProjects() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.isAccessible()) {
                this.clean(p, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    public void cleanLibraries(IProgressMonitor monitor) {
        if (monitor == null) {
            throw new IllegalArgumentException("The progress monitor should not be null");
        }
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask(Messages.PHPGlobalIndexer_rebuildingLibraries, 3);
        BuildPathManager buildPathManager = BuildPathManager.getInstance();
        List<IBuildPath> buildPaths = buildPathManager.getBuildPaths();
        for (IBuildPath buildPath : buildPaths) {
            if (buildPath instanceof FileSystemBuildPath) {
                File indexFile = this.getIndexFile(buildPath);
                if (indexFile != null && indexFile.exists()) {
                    indexFile.delete();
                    if (monitor.isCanceled()) {
                        return;
                    }
                }
                if (monitor.isCanceled()) {
                    return;
                }
                buildPathManager.removeBuildPath(((FileSystemBuildPath)buildPath).getFile());
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        buildPathManager.indexExternalLibraries();
        monitor.worked(1);
        if (monitor.isCanceled()) {
            return;
        }
        PHPBuiltins.getInstance().clean(monitor);
        monitor.done();
    }

    private static final class WrapIndexer
    implements IModuleIndexer,
    IProgramIndexer {
        private final IConfigurationElement element;
        private IModuleIndexer indexer;

        private WrapIndexer(IConfigurationElement element) {
            this.element = element;
        }

        @Override
        public void indexModule(IModule module, IIndexReporter reporter) {
            try {
                this.initIfNeeded();
                this.indexer.indexModule(module, reporter);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing a PHP module", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
        }

        @Override
        public void indexModule(Program program, IModule module, String source, IIndexReporter reporter) {
            try {
                this.initIfNeeded();
                if (this.indexer instanceof IProgramIndexer) {
                    IProgramIndexer pi = (IProgramIndexer)((Object)this.indexer);
                    pi.indexModule(program, module, source, reporter);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing a PHP module", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
        }

        private void initIfNeeded() throws CoreException {
            if (this.indexer == null) {
                this.indexer = (IModuleIndexer)this.element.createExecutableExtension(PHPGlobalIndexer.CLASS_ATTRIBUTE_NAME);
            }
        }

        @Override
        public void indexModule(Program program, IModule module, IIndexReporter reporter) {
            try {
                this.initIfNeeded();
                if (this.indexer instanceof IProgramIndexer) {
                    IProgramIndexer pi = (IProgramIndexer)((Object)this.indexer);
                    pi.indexModule(program, module, reporter);
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error indexing a PHP module", (Throwable)e, (String)"com.aptana.editor.php/debug/indexer");
            }
        }
    }
}

